<?php

/**
 * @file
 */

/**
 * Test Generated example demonstrating the Contact.getfields API.
 *
 * Demonstrates retrieving metadata with custom field options.
 *
 * @return array
 *   API result array
 */
function contact_getfields_example() {
  $params = [
    'options' => [
      'get_options' => 'custom_1',
    ],
    'action' => 'create',
  ];

  try {
    $result = civicrm_api3('Contact', 'getfields', $params);
  }
  catch (CRM_Core_Exception $e) {
    // Handle error here.
    $errorMessage = $e->getMessage();
    $errorCode = $e->getErrorCode();
    $errorData = $e->getExtraParams();
    return [
      'is_error' => 1,
      'error_message' => $errorMessage,
      'error_code' => $errorCode,
      'error_data' => $errorData,
    ];
  }

  return $result;
}

/**
 * Function returns array of result expected from previous function.
 *
 * @return array
 *   API result array
 */
function contact_getfields_expectedresult() {

  $expectedResult = [
    'is_error' => 0,
    'version' => 3,
    'count' => 56,
    'values' => [
      'id' => [
        'name' => 'id',
        'type' => 1,
        'title' => 'Contact ID',
        'description' => 'Unique Contact ID',
        'required' => TRUE,
        'import' => TRUE,
        'where' => 'civicrm_contact.id',
        'headerPattern' => '/internal|contact?|id$/i',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Number',
          'size' => 6,
          'maxlength' => 14,
        ],
        'readonly' => TRUE,
        'add' => '1.1',
        'is_core_field' => TRUE,
        'api.aliases' => [
          '0' => 'contact_id',
        ],
      ],
      'contact_type' => [
        'name' => 'contact_type',
        'type' => 2,
        'title' => 'Contact Type',
        'description' => 'Type of Contact.',
        'maxlength' => 64,
        'size' => 30,
        'where' => 'civicrm_contact.contact_type',
        'export' => TRUE,
        'contactType' => '',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select',
          'maxlength' => 64,
          'size' => 30,
        ],
        'pseudoconstant' => [
          'table' => 'civicrm_contact_type',
          'keyColumn' => 'name',
          'labelColumn' => 'label',
          'condition' => 'parent_id IS NULL',
        ],
        'readonly' => TRUE,
        'add' => '1.1',
        'is_core_field' => TRUE,
        'api.required' => 1,
      ],
      'contact_sub_type' => [
        'name' => 'contact_sub_type',
        'type' => 2,
        'title' => 'Contact Subtype',
        'description' => 'May be used to over-ride contact view and edit templates.',
        'maxlength' => 255,
        'size' => 45,
        'import' => TRUE,
        'where' => 'civicrm_contact.contact_sub_type',
        'headerPattern' => '/C(ontact )?(subtype|sub-type|sub type)/i',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'serialize' => 1,
        'html' => [
          'type' => 'Select',
          'maxlength' => 255,
          'size' => 45,
        ],
        'pseudoconstant' => [
          'table' => 'civicrm_contact_type',
          'keyColumn' => 'name',
          'labelColumn' => 'label',
          'condition' => 'parent_id IS NOT NULL',
        ],
        'add' => '1.5',
        'is_core_field' => TRUE,
      ],
      'do_not_email' => [
        'name' => 'do_not_email',
        'type' => 16,
        'title' => 'Do Not Email',
        'import' => TRUE,
        'where' => 'civicrm_contact.do_not_email',
        'headerPattern' => '/d(o )?(not )?(email)/i',
        'dataPattern' => '/^\\d{1,}$/',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'CheckBox',
          'label' => 'Do Not Email',
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'do_not_phone' => [
        'name' => 'do_not_phone',
        'type' => 16,
        'title' => 'Do Not Phone',
        'import' => TRUE,
        'where' => 'civicrm_contact.do_not_phone',
        'headerPattern' => '/d(o )?(not )?(call|phone)/i',
        'dataPattern' => '/^\\d{1,}$/',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'CheckBox',
          'label' => 'Do Not Phone',
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'do_not_mail' => [
        'name' => 'do_not_mail',
        'type' => 16,
        'title' => 'Do Not Mail',
        'import' => TRUE,
        'where' => 'civicrm_contact.do_not_mail',
        'headerPattern' => '/^(d(o\\s)?n(ot\\s)?mail)|(\\w*)?bulk\\s?(\\w*)$/i',
        'dataPattern' => '/^\\d{1,}$/',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'CheckBox',
          'label' => 'Do Not Mail',
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'do_not_sms' => [
        'name' => 'do_not_sms',
        'type' => 16,
        'title' => 'Do Not Sms',
        'import' => TRUE,
        'where' => 'civicrm_contact.do_not_sms',
        'headerPattern' => '/d(o )?(not )?(sms)/i',
        'dataPattern' => '/^\\d{1,}$/',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'CheckBox',
          'label' => 'Do Not Sms',
        ],
        'add' => '3.0',
        'is_core_field' => TRUE,
      ],
      'do_not_trade' => [
        'name' => 'do_not_trade',
        'type' => 16,
        'title' => 'Do Not Trade',
        'import' => TRUE,
        'where' => 'civicrm_contact.do_not_trade',
        'headerPattern' => '/d(o )?(not )?(trade)/i',
        'dataPattern' => '/^\\d{1,}$/',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'CheckBox',
          'label' => 'Do Not Trade',
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'is_opt_out' => [
        'name' => 'is_opt_out',
        'type' => 16,
        'title' => 'No Bulk Emails (User Opt Out)',
        'description' => 'Has the contact opted out from receiving all bulk email from the organization or site domain?',
        'required' => TRUE,
        'import' => TRUE,
        'where' => 'civicrm_contact.is_opt_out',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'CheckBox',
          'label' => 'Is Opt Out',
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'legal_identifier' => [
        'name' => 'legal_identifier',
        'type' => 2,
        'title' => 'Legal Identifier',
        'description' => 'May be used for SSN, EIN/TIN, Household ID (census) or other applicable unique legal/government ID.',
        'maxlength' => 32,
        'size' => 20,
        'import' => TRUE,
        'where' => 'civicrm_contact.legal_identifier',
        'headerPattern' => '/legal\\s?id/i',
        'dataPattern' => '/\\w+?\\d{5,}/',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'Legal Identifier',
          'maxlength' => 32,
          'size' => 20,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'external_identifier' => [
        'name' => 'external_identifier',
        'type' => 2,
        'title' => 'External Identifier',
        'description' => 'Unique trusted external ID (generally from a legacy app/datasource). Particularly useful for deduping operations.',
        'maxlength' => 64,
        'size' => 8,
        'import' => TRUE,
        'where' => 'civicrm_contact.external_identifier',
        'headerPattern' => '/external\\s?id/i',
        'dataPattern' => '/^\\d{11,}$/',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'External Identifier',
          'maxlength' => 64,
          'size' => 8,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'sort_name' => [
        'name' => 'sort_name',
        'type' => 2,
        'title' => 'Sort Name',
        'description' => 'Name used for sorting different contact types',
        'maxlength' => 128,
        'size' => 30,
        'where' => 'civicrm_contact.sort_name',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'maxlength' => 128,
          'size' => 30,
        ],
        'readonly' => TRUE,
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'display_name' => [
        'name' => 'display_name',
        'type' => 2,
        'title' => 'Display Name',
        'description' => 'Formatted name representing preferred format for display/print/other output.',
        'maxlength' => 128,
        'size' => 30,
        'where' => 'civicrm_contact.display_name',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'maxlength' => 128,
          'size' => 30,
        ],
        'readonly' => TRUE,
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'nick_name' => [
        'name' => 'nick_name',
        'type' => 2,
        'title' => 'Nickname',
        'description' => 'Nickname.',
        'maxlength' => 128,
        'size' => 30,
        'import' => TRUE,
        'where' => 'civicrm_contact.nick_name',
        'headerPattern' => '/n(ick\\s)name|nick$/i',
        'dataPattern' => '/^\\w+$/',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'maxlength' => 128,
          'size' => 30,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'legal_name' => [
        'name' => 'legal_name',
        'type' => 2,
        'title' => 'Legal Name',
        'description' => 'Legal Name.',
        'maxlength' => 128,
        'size' => 30,
        'import' => TRUE,
        'where' => 'civicrm_contact.legal_name',
        'headerPattern' => '/^legal|(l(egal\\s)?name)$/i',
        'export' => TRUE,
        'contactType' => 'Organization',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'Legal Name',
          'maxlength' => 128,
          'size' => 30,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'image_URL' => [
        'name' => 'image_URL',
        'type' => 32,
        'title' => 'Image Url',
        'description' => 'optional URL for preferred image (photo, logo, etc.) to display for this contact.',
        'import' => TRUE,
        'where' => 'civicrm_contact.image_URL',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'File',
          'label' => 'Image URL',
          'rows' => 2,
          'cols' => 80,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'preferred_communication_method' => [
        'name' => 'preferred_communication_method',
        'type' => 2,
        'title' => 'Preferred Communication Method',
        'description' => 'What is the preferred mode of communication.',
        'maxlength' => 255,
        'size' => 45,
        'import' => TRUE,
        'where' => 'civicrm_contact.preferred_communication_method',
        'headerPattern' => '/^p(ref\\w*\\s)?c(omm\\w*)|( meth\\w*)$/i',
        'dataPattern' => '/^\\w+$/',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'serialize' => 1,
        'html' => [
          'type' => 'Select',
          'maxlength' => 255,
          'size' => 45,
        ],
        'pseudoconstant' => [
          'optionGroupName' => 'preferred_communication_method',
          'optionEditPath' => 'civicrm/admin/options/preferred_communication_method',
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'preferred_language' => [
        'name' => 'preferred_language',
        'type' => 2,
        'title' => 'Preferred Language',
        'description' => 'Which language is preferred for communication. FK to languages in civicrm_option_value.',
        'maxlength' => 5,
        'size' => 6,
        'import' => TRUE,
        'where' => 'civicrm_contact.preferred_language',
        'headerPattern' => '/^lang/i',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select',
          'maxlength' => 5,
          'size' => 6,
        ],
        'pseudoconstant' => [
          'optionGroupName' => 'languages',
          'keyColumn' => 'name',
          'optionEditPath' => 'civicrm/admin/options/languages',
        ],
        'add' => '3.2',
        'is_core_field' => TRUE,
      ],
      'preferred_mail_format' => [
        'name' => 'preferred_mail_format',
        'type' => 2,
        'title' => 'Preferred Mail Format',
        'description' => 'What is the preferred mode of sending an email.',
        'maxlength' => 8,
        'size' => 8,
        'import' => TRUE,
        'where' => 'civicrm_contact.preferred_mail_format',
        'headerPattern' => '/^p(ref\\w*\\s)?m(ail\\s)?f(orm\\w*)$/i',
        'export' => TRUE,
        'default' => 'Both',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select',
          'label' => 'Preferred Mail Format',
          'maxlength' => 8,
          'size' => 8,
        ],
        'pseudoconstant' => [
          'callback' => 'CRM_Core_SelectValues::pmf',
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'hash' => [
        'name' => 'hash',
        'type' => 2,
        'title' => 'Contact Hash',
        'description' => 'Key for validating requests related to this contact.',
        'maxlength' => 32,
        'size' => 20,
        'where' => 'civicrm_contact.hash',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'readonly' => TRUE,
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'api_key' => [
        'name' => 'api_key',
        'type' => 2,
        'title' => 'Api Key',
        'description' => 'API Key for validating requests related to this contact.',
        'maxlength' => 32,
        'size' => 20,
        'where' => 'civicrm_contact.api_key',
        'permission' => [
          '0' => [
            '0' => 'administer CiviCRM',
            '1' => 'edit api keys',
          ],
        ],
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'label' => 'API KEY',
          'maxlength' => 32,
          'size' => 20,
        ],
        'readonly' => TRUE,
        'add' => '2.2',
        'is_core_field' => TRUE,
      ],
      'first_name' => [
        'name' => 'first_name',
        'type' => 2,
        'title' => 'First Name',
        'description' => 'First Name.',
        'maxlength' => 64,
        'size' => 30,
        'import' => TRUE,
        'where' => 'civicrm_contact.first_name',
        'headerPattern' => '/^first|(f(irst\\s)?name)$/i',
        'dataPattern' => '/^\\w+$/',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'First Name',
          'maxlength' => 64,
          'size' => 30,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'middle_name' => [
        'name' => 'middle_name',
        'type' => 2,
        'title' => 'Middle Name',
        'description' => 'Middle Name.',
        'maxlength' => 64,
        'size' => 30,
        'import' => TRUE,
        'where' => 'civicrm_contact.middle_name',
        'headerPattern' => '/^middle|(m(iddle\\s)?name)$/i',
        'dataPattern' => '/^\\w+$/',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'Middle Name',
          'maxlength' => 64,
          'size' => 30,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'last_name' => [
        'name' => 'last_name',
        'type' => 2,
        'title' => 'Last Name',
        'description' => 'Last Name.',
        'maxlength' => 64,
        'size' => 30,
        'import' => TRUE,
        'where' => 'civicrm_contact.last_name',
        'headerPattern' => '/^last|(l(ast\\s)?name)$/i',
        'dataPattern' => '/^\\w+(\\s\\w+)?+$/',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'Last Name',
          'maxlength' => 64,
          'size' => 30,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'prefix_id' => [
        'name' => 'prefix_id',
        'type' => 1,
        'title' => 'Individual Prefix',
        'description' => 'Prefix or Title for name (Ms, Mr...). FK to prefix ID',
        'import' => TRUE,
        'where' => 'civicrm_contact.prefix_id',
        'headerPattern' => '/^(prefix|title)/i',
        'dataPattern' => '/^(mr|ms|mrs|sir|dr)\\.?$/i',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select',
          'size' => 6,
          'maxlength' => 14,
        ],
        'pseudoconstant' => [
          'optionGroupName' => 'individual_prefix',
          'optionEditPath' => 'civicrm/admin/options/individual_prefix',
        ],
        'add' => '1.2',
        'is_core_field' => TRUE,
        'api.aliases' => [
          '0' => 'individual_prefix',
          '1' => 'individual_prefix_id',
        ],
      ],
      'suffix_id' => [
        'name' => 'suffix_id',
        'type' => 1,
        'title' => 'Individual Suffix',
        'description' => 'Suffix for name (Jr, Sr...). FK to suffix ID',
        'import' => TRUE,
        'where' => 'civicrm_contact.suffix_id',
        'headerPattern' => '/^suffix$/i',
        'dataPattern' => '/^(sr|jr)\\.?|i{2,}$/',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select',
          'size' => 6,
          'maxlength' => 14,
        ],
        'pseudoconstant' => [
          'optionGroupName' => 'individual_suffix',
          'optionEditPath' => 'civicrm/admin/options/individual_suffix',
        ],
        'add' => '1.2',
        'is_core_field' => TRUE,
        'api.aliases' => [
          '0' => 'individual_suffix',
          '1' => 'individual_suffix_id',
        ],
      ],
      'formal_title' => [
        'name' => 'formal_title',
        'type' => 2,
        'title' => 'Formal Title',
        'description' => 'Formal (academic or similar) title in front of name. (Prof., Dr. etc.)',
        'maxlength' => 64,
        'size' => 30,
        'import' => TRUE,
        'where' => 'civicrm_contact.formal_title',
        'headerPattern' => '/^title/i',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'Formal Title',
          'maxlength' => 64,
          'size' => 30,
        ],
        'add' => '4.5',
        'is_core_field' => TRUE,
      ],
      'communication_style_id' => [
        'name' => 'communication_style_id',
        'type' => 1,
        'title' => 'Communication Style',
        'description' => 'Communication style (e.g. formal vs. familiar) to use with this contact. FK to communication styles in civicrm_option_value.',
        'import' => TRUE,
        'where' => 'civicrm_contact.communication_style_id',
        'headerPattern' => '/style/i',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select',
          'size' => 6,
          'maxlength' => 14,
        ],
        'pseudoconstant' => [
          'optionGroupName' => 'communication_style',
          'optionEditPath' => 'civicrm/admin/options/communication_style',
        ],
        'add' => '4.4',
        'is_core_field' => TRUE,
      ],
      'email_greeting_id' => [
        'name' => 'email_greeting_id',
        'type' => 1,
        'title' => 'Email Greeting ID',
        'description' => 'FK to civicrm_option_value.id, that has to be valid registered Email Greeting.',
        'where' => 'civicrm_contact.email_greeting_id',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select',
          'size' => 6,
          'maxlength' => 14,
        ],
        'pseudoconstant' => [
          'optionGroupName' => 'email_greeting',
          'optionEditPath' => 'civicrm/admin/options/email_greeting',
        ],
        'add' => '3.0',
        'is_core_field' => TRUE,
      ],
      'email_greeting_custom' => [
        'name' => 'email_greeting_custom',
        'type' => 2,
        'title' => 'Email Greeting Custom',
        'description' => 'Custom Email Greeting.',
        'maxlength' => 128,
        'size' => 45,
        'import' => TRUE,
        'where' => 'civicrm_contact.email_greeting_custom',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'Email Greeting Custom',
          'maxlength' => 128,
          'size' => 45,
        ],
        'add' => '3.0',
        'is_core_field' => TRUE,
      ],
      'email_greeting_display' => [
        'name' => 'email_greeting_display',
        'type' => 2,
        'title' => 'Email Greeting',
        'description' => 'Cache Email Greeting.',
        'maxlength' => 255,
        'size' => 45,
        'where' => 'civicrm_contact.email_greeting_display',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'readonly' => TRUE,
        'add' => '3.0',
        'is_core_field' => TRUE,
      ],
      'postal_greeting_id' => [
        'name' => 'postal_greeting_id',
        'type' => 1,
        'title' => 'Postal Greeting ID',
        'description' => 'FK to civicrm_option_value.id, that has to be valid registered Postal Greeting.',
        'where' => 'civicrm_contact.postal_greeting_id',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select',
          'size' => 6,
          'maxlength' => 14,
        ],
        'pseudoconstant' => [
          'optionGroupName' => 'postal_greeting',
          'optionEditPath' => 'civicrm/admin/options/postal_greeting',
        ],
        'add' => '3.0',
        'is_core_field' => TRUE,
      ],
      'postal_greeting_custom' => [
        'name' => 'postal_greeting_custom',
        'type' => 2,
        'title' => 'Postal Greeting Custom',
        'description' => 'Custom Postal greeting.',
        'maxlength' => 128,
        'size' => 45,
        'import' => TRUE,
        'where' => 'civicrm_contact.postal_greeting_custom',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'Postal Greeting Custom',
          'maxlength' => 128,
          'size' => 45,
        ],
        'add' => '3.0',
        'is_core_field' => TRUE,
      ],
      'postal_greeting_display' => [
        'name' => 'postal_greeting_display',
        'type' => 2,
        'title' => 'Postal Greeting',
        'description' => 'Cache Postal greeting.',
        'maxlength' => 255,
        'size' => 45,
        'where' => 'civicrm_contact.postal_greeting_display',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'readonly' => TRUE,
        'add' => '3.0',
        'is_core_field' => TRUE,
      ],
      'addressee_id' => [
        'name' => 'addressee_id',
        'type' => 1,
        'title' => 'Addressee ID',
        'description' => 'FK to civicrm_option_value.id, that has to be valid registered Addressee.',
        'where' => 'civicrm_contact.addressee_id',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select',
          'size' => 6,
          'maxlength' => 14,
        ],
        'pseudoconstant' => [
          'optionGroupName' => 'addressee',
          'optionEditPath' => 'civicrm/admin/options/addressee',
        ],
        'add' => '3.0',
        'is_core_field' => TRUE,
      ],
      'addressee_custom' => [
        'name' => 'addressee_custom',
        'type' => 2,
        'title' => 'Addressee Custom',
        'description' => 'Custom Addressee.',
        'maxlength' => 128,
        'size' => 45,
        'import' => TRUE,
        'where' => 'civicrm_contact.addressee_custom',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'Addressee Custom',
          'maxlength' => 128,
          'size' => 45,
        ],
        'add' => '3.0',
        'is_core_field' => TRUE,
      ],
      'addressee_display' => [
        'name' => 'addressee_display',
        'type' => 2,
        'title' => 'Addressee',
        'description' => 'Cache Addressee.',
        'maxlength' => 255,
        'size' => 45,
        'where' => 'civicrm_contact.addressee_display',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'readonly' => TRUE,
        'add' => '3.0',
        'is_core_field' => TRUE,
      ],
      'job_title' => [
        'name' => 'job_title',
        'type' => 2,
        'title' => 'Job Title',
        'description' => 'Job Title',
        'maxlength' => 255,
        'size' => 30,
        'import' => TRUE,
        'where' => 'civicrm_contact.job_title',
        'headerPattern' => '/^job|(j(ob\\s)?title)$/i',
        'dataPattern' => '//',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'Job Title',
          'maxlength' => 255,
          'size' => 30,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'gender_id' => [
        'name' => 'gender_id',
        'type' => 1,
        'title' => 'Gender ID',
        'description' => 'FK to gender ID',
        'import' => TRUE,
        'where' => 'civicrm_contact.gender_id',
        'headerPattern' => '/^gender$/i',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select',
          'label' => 'Gender',
          'size' => 6,
          'maxlength' => 14,
        ],
        'pseudoconstant' => [
          'optionGroupName' => 'gender',
          'optionEditPath' => 'civicrm/admin/options/gender',
        ],
        'add' => '1.2',
        'is_core_field' => TRUE,
        'api.aliases' => [
          '0' => 'gender',
        ],
      ],
      'birth_date' => [
        'name' => 'birth_date',
        'type' => 4,
        'title' => 'Birth Date',
        'description' => 'Date of birth',
        'import' => TRUE,
        'where' => 'civicrm_contact.birth_date',
        'headerPattern' => '/^birth|(b(irth\\s)?date)|D(\\W*)O(\\W*)B(\\W*)$/i',
        'dataPattern' => '/\\d{4}-?\\d{2}-?\\d{2}/',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select Date',
          'formatType' => 'birth',
          'label' => 'Birth Date',
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'is_deceased' => [
        'name' => 'is_deceased',
        'type' => 16,
        'title' => 'Deceased',
        'required' => TRUE,
        'import' => TRUE,
        'where' => 'civicrm_contact.is_deceased',
        'headerPattern' => '/i(s\\s)?d(eceased)$/i',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'CheckBox',
          'label' => 'Is Deceased',
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'deceased_date' => [
        'name' => 'deceased_date',
        'type' => 4,
        'title' => 'Deceased Date',
        'description' => 'Date of deceased',
        'import' => TRUE,
        'where' => 'civicrm_contact.deceased_date',
        'headerPattern' => '/^deceased|(d(eceased\\s)?date)$/i',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Select Date',
          'formatType' => 'birth',
          'label' => 'Deceased Date',
        ],
        'add' => '1.5',
        'is_core_field' => TRUE,
      ],
      'household_name' => [
        'name' => 'household_name',
        'type' => 2,
        'title' => 'Household Name',
        'description' => 'Household Name.',
        'maxlength' => 128,
        'size' => 30,
        'import' => TRUE,
        'where' => 'civicrm_contact.household_name',
        'headerPattern' => '/^household|(h(ousehold\\s)?name)$/i',
        'dataPattern' => '/^\\w+$/',
        'export' => TRUE,
        'contactType' => 'Household',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'Household Name',
          'maxlength' => 128,
          'size' => 30,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'primary_contact_id' => [
        'name' => 'primary_contact_id',
        'type' => 1,
        'title' => 'Household Primary Contact ID',
        'description' => 'Optional FK to Primary Contact for this household.',
        'where' => 'civicrm_contact.primary_contact_id',
        'contactType' => 'Household',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'FKClassName' => 'CRM_Contact_DAO_Contact',
        'html' => [
          'label' => 'Household Primary Contact',
          'size' => 6,
          'maxlength' => 14,
        ],
        'readonly' => TRUE,
        'add' => '1.1',
        'is_core_field' => TRUE,
        'FKApiName' => 'Contact',
      ],
      'organization_name' => [
        'name' => 'organization_name',
        'type' => 2,
        'title' => 'Organization Name',
        'description' => 'Organization Name.',
        'maxlength' => 128,
        'size' => 30,
        'import' => TRUE,
        'where' => 'civicrm_contact.organization_name',
        'headerPattern' => '/^organization|(o(rganization\\s)?name)$/i',
        'dataPattern' => '/^\\w+$/',
        'export' => TRUE,
        'contactType' => 'Organization',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'Organization Name',
          'maxlength' => 128,
          'size' => 30,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'sic_code' => [
        'name' => 'sic_code',
        'type' => 2,
        'title' => 'Sic Code',
        'description' => 'Standard Industry Classification Code.',
        'maxlength' => 8,
        'size' => 8,
        'import' => TRUE,
        'where' => 'civicrm_contact.sic_code',
        'headerPattern' => '/^sic|(s(ic\\s)?code)$/i',
        'export' => TRUE,
        'contactType' => 'Organization',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'label' => 'SIC Code',
          'maxlength' => 8,
          'size' => 8,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
      ],
      'user_unique_id' => [
        'name' => 'user_unique_id',
        'type' => 2,
        'title' => 'Unique ID (OpenID)',
        'description' => 'the OpenID (or OpenID-style http://username.domain/) unique identifier for this contact mainly used for logging in to CiviCRM',
        'maxlength' => 255,
        'size' => 45,
        'import' => TRUE,
        'where' => 'civicrm_contact.user_unique_id',
        'headerPattern' => '/^Open\\s?ID|u(niq\\w*)?\\s?ID/i',
        'dataPattern' => '/^[\\w\\/\\:\\.]+$/',
        'export' => TRUE,
        'rule' => 'url',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'maxlength' => 255,
          'size' => 45,
        ],
        'add' => '2.0',
        'is_core_field' => TRUE,
      ],
      'created_date' => [
        'name' => 'created_date',
        'type' => 256,
        'title' => 'Created Date',
        'description' => 'When was the contact was created.',
        'required' => '',
        'where' => 'civicrm_contact.created_date',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'label' => 'Created Date',
        ],
        'add' => '4.3',
        'is_core_field' => TRUE,
      ],
      'modified_date' => [
        'name' => 'modified_date',
        'type' => 256,
        'title' => 'Modified Date',
        'description' => 'When was the contact (or closely related entity) was created or modified or deleted.',
        'required' => '',
        'where' => 'civicrm_contact.modified_date',
        'export' => TRUE,
        'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'label' => 'Modified Date',
        ],
        'readonly' => TRUE,
        'add' => '4.3',
        'is_core_field' => TRUE,
      ],
      'source' => [
        'name' => 'source',
        'type' => 2,
        'title' => 'Contact Source',
        'description' => 'where contact come from, e.g. import, donate module insert...',
        'maxlength' => 255,
        'size' => 30,
        'import' => TRUE,
        'where' => 'civicrm_contact.source',
        'headerPattern' => '/(C(ontact\\s)?Source)$/i',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'Text',
          'maxlength' => 255,
          'size' => 30,
        ],
        'add' => '1.1',
        'is_core_field' => TRUE,
        'uniqueName' => 'contact_source',
      ],
      'employer_id' => [
        'name' => 'employer_id',
        'type' => 1,
        'title' => 'Current Employer ID',
        'description' => 'OPTIONAL FK to civicrm_contact record.',
        'where' => 'civicrm_contact.employer_id',
        'export' => TRUE,
        'contactType' => 'Individual',
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'FKClassName' => 'CRM_Contact_DAO_Contact',
        'html' => [
          'type' => 'EntityRef',
          'label' => 'Current Employer',
          'size' => 6,
          'maxlength' => 14,
        ],
        'add' => '2.1',
        'is_core_field' => TRUE,
        'uniqueName' => 'current_employer_id',
        'FKApiName' => 'Contact',
      ],
      'is_deleted' => [
        'name' => 'is_deleted',
        'type' => 16,
        'title' => 'Contact is in Trash',
        'required' => TRUE,
        'where' => 'civicrm_contact.is_deleted',
        'export' => TRUE,
        'table_name' => 'civicrm_contact',
        'entity' => 'Contact',
        'bao' => 'CRM_Contact_BAO_Contact',
        'localizable' => 0,
        'html' => [
          'type' => 'CheckBox',
        ],
        'add' => '3.2',
        'is_core_field' => TRUE,
        'uniqueName' => 'contact_is_deleted',
      ],
      'custom_1' => [
        'id' => '1',
        'label' => 'Our special field',
        'headerPattern' => '//',
        'title' => 'Our special field',
        'custom_field_id' => '1',
        'groupTitle' => 'select_test_group',
        'data_type' => 'String',
        'name' => 'custom_1',
        'type' => 2,
        'html_type' => 'Select',
        'default_value' => '',
        'text_length' => '',
        'options_per_line' => '',
        'custom_group_id' => '1',
        'extends' => 'Contact',
        'is_search_range' => 0,
        'extends_entity_column_value' => '',
        'extends_entity_column_id' => '',
        'is_view' => 0,
        'is_multiple' => 0,
        'option_group_id' => '109',
        'date_format' => '',
        'time_format' => '',
        'is_required' => '1',
        'table_name' => 'civicrm_value_select_test_g_1',
        'column_name' => 'our_special_field_1',
        'serialize' => 0,
        'where' => 'civicrm_value_select_test_g_1.our_special_field_1',
        'extends_table' => 'civicrm_contact',
        'search_table' => 'contact_a',
        'pseudoconstant' => [
          'optionGroupName' => 'our_special_field_20220117122549',
          'optionEditPath' => 'civicrm/admin/options/our_special_field_20220117122549',
        ],
        'options' => [
          '1' => 'Label1',
          '2' => 'Label2',
        ],
      ],
      'current_employer' => [
        'title' => 'Current Employer',
        'description' => 'Name of Current Employer',
        'type' => 2,
        'name' => 'current_employer',
      ],
      'dupe_check' => [
        'title' => 'Check for Duplicates',
        'description' => 'Throw error if contact create matches dedupe rule',
        'type' => 16,
        'name' => 'dupe_check',
      ],
      'skip_greeting_processing' => [
        'title' => 'Skip Greeting processing',
        'description' => 'Do not process greetings, (these can be done by scheduled job and there may be a preference to do so for performance reasons)',
        'type' => 16,
        'api.default' => 0,
        'name' => 'skip_greeting_processing',
      ],
    ],
  ];

  return $expectedResult;
}

/*
 * This example has been generated from the API test suite.
 * The test that created it is called "testCustomFieldCreateWithOptionValues"
 * and can be found at:
 * https://github.com/civicrm/civicrm-core/blob/master/tests/phpunit/api/v3/ContactTest.php
 *
 * You can see the outcome of the API tests at
 * https://test.civicrm.org/job/CiviCRM-Core-Matrix/
 *
 * To Learn about the API read
 * https://docs.civicrm.org/dev/en/latest/api/
 *
 * Browse the API on your own site with the API Explorer. It is in the main
 * CiviCRM menu, under: Support > Development > API Explorer.
 *
 * Read more about testing here
 * https://docs.civicrm.org/dev/en/latest/testing/
 *
 * API Standards documentation:
 * https://docs.civicrm.org/dev/en/latest/framework/api-architecture/
 */
