<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from org.civicrm.contactlayout/xml/schema/CRM/Contactlayout/ContactLayout.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:b63665b0d24acdccb0da6c17ad580b43)
 */
use CRM_Contactlayout_ExtensionUtil as E;

/**
 * Database access object for the ContactLayout entity.
 */
class CRM_Contactlayout_DAO_ContactLayout extends CRM_Core_DAO {
  const EXT = E::LONG_NAME;
  const TABLE_ADDED = '1.0';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_contact_layout';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Unique ContactLayout ID
   *
   * @var int
   */
  public $id;

  /**
   * Name of this layout.
   *
   * @var string
   */
  public $label;

  /**
   * The type of contacts this layout applies to.
   *
   * @var string
   */
  public $contact_type;

  /**
   * The contacts subtypes this layout applies to.
   *
   * @var string
   */
  public $contact_sub_type;

  /**
   * Show layout to users belonging to these groups.
   *
   * @var string
   */
  public $groups;

  /**
   * @var int
   */
  public $weight;

  /**
   * Contains json encoded layout blocks.
   *
   * @var longtext
   */
  public $blocks;

  /**
   * Contains json encoded layout tabs.
   *
   * @var longtext
   */
  public $tabs;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_contact_layout';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? E::ts('Contact Summary Layouts') : E::ts('Contact Summary Layout');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'description' => E::ts('Unique ContactLayout ID'),
          'required' => TRUE,
          'where' => 'civicrm_contact_layout.id',
          'table_name' => 'civicrm_contact_layout',
          'entity' => 'ContactLayout',
          'bao' => 'CRM_Contactlayout_DAO_ContactLayout',
          'localizable' => 0,
          'readonly' => TRUE,
          'add' => '1.0',
        ],
        'label' => [
          'name' => 'label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Label'),
          'description' => E::ts('Name of this layout.'),
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_contact_layout.label',
          'table_name' => 'civicrm_contact_layout',
          'entity' => 'ContactLayout',
          'bao' => 'CRM_Contactlayout_DAO_ContactLayout',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.0',
        ],
        'contact_type' => [
          'name' => 'contact_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Contact Type'),
          'description' => E::ts('The type of contacts this layout applies to.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_contact_layout.contact_type',
          'table_name' => 'civicrm_contact_layout',
          'entity' => 'ContactLayout',
          'bao' => 'CRM_Contactlayout_DAO_ContactLayout',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_contact_type',
            'keyColumn' => 'name',
            'labelColumn' => 'label',
            'condition' => 'parent_id IS NULL',
          ],
          'add' => '1.0',
        ],
        'contact_sub_type' => [
          'name' => 'contact_sub_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Contact Subtype'),
          'description' => E::ts('The contacts subtypes this layout applies to.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_contact_layout.contact_sub_type',
          'table_name' => 'civicrm_contact_layout',
          'entity' => 'ContactLayout',
          'bao' => 'CRM_Contactlayout_DAO_ContactLayout',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_BOOKEND,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_contact_type',
            'keyColumn' => 'name',
            'labelColumn' => 'label',
            'condition' => 'parent_id IS NOT NULL',
          ],
          'add' => '1.0',
        ],
        'groups' => [
          'name' => 'groups',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Groups'),
          'description' => E::ts('Show layout to users belonging to these groups.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_contact_layout.groups',
          'table_name' => 'civicrm_contact_layout',
          'entity' => 'ContactLayout',
          'bao' => 'CRM_Contactlayout_DAO_ContactLayout',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_BOOKEND,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_group',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
          ],
          'add' => '1.0',
        ],
        'weight' => [
          'name' => 'weight',
          'type' => CRM_Utils_Type::T_INT,
          'title' => E::ts('Order'),
          'where' => 'civicrm_contact_layout.weight',
          'default' => '0',
          'table_name' => 'civicrm_contact_layout',
          'entity' => 'ContactLayout',
          'bao' => 'CRM_Contactlayout_DAO_ContactLayout',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.0',
        ],
        'blocks' => [
          'name' => 'blocks',
          'type' => CRM_Utils_Type::T_LONGTEXT,
          'title' => E::ts('Blocks'),
          'description' => E::ts('Contains json encoded layout blocks.'),
          'required' => TRUE,
          'where' => 'civicrm_contact_layout.blocks',
          'table_name' => 'civicrm_contact_layout',
          'entity' => 'ContactLayout',
          'bao' => 'CRM_Contactlayout_DAO_ContactLayout',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_JSON,
          'add' => '1.0',
        ],
        'tabs' => [
          'name' => 'tabs',
          'type' => CRM_Utils_Type::T_LONGTEXT,
          'title' => E::ts('Tabs'),
          'description' => E::ts('Contains json encoded layout tabs.'),
          'where' => 'civicrm_contact_layout.tabs',
          'table_name' => 'civicrm_contact_layout',
          'entity' => 'ContactLayout',
          'bao' => 'CRM_Contactlayout_DAO_ContactLayout',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_JSON,
          'add' => '1.2',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'contact_layout', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'contact_layout', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
